﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Świadectwo pracy</title>
		<script runat="server">

            public class StaticParams : SerializableContextBase {

                public StaticParams(Context context): base(context) {
                    KalendModule kalend = KalendModule.GetInstance(this);
                    PlaceModule place = PlaceModule.GetInstance(this);
                    if (urlopOjcowski == null)
                        urlopOjcowski = kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0038-000000000000")];
                    if (urlopMacierzynski == null)
                        urlopMacierzynski = new DefinicjaNieobecnosci[] {
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0040-000000000000")],
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0044-000000000000")],
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0045-000000000000")] };
                    if (ekwiwalentUrlop == null)
                        ekwiwalentUrlop = place.DefElementow[new Guid("00000000-0007-0002-0074-000000000000")];
                    if (ekwiwalentUrlopDodatkowy == null)
                        ekwiwalentUrlopDodatkowy = place.DefElementow[new Guid("00000000-0007-0002-0156-000000000000")];
                }

                bool wychowJakoBezskładkowy = false;
                [Priority(10)]
                [Caption("Wychow.jako bezskładk.")]
                public bool WychowJakoBezskładkowy {
                    get { return wychowJakoBezskładkowy; }
                    set {
                        wychowJakoBezskładkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool bezplatnyJakoBezskładkowy = false;
                [Priority(20)]
                [Caption("Bezpłatn.jako bezskładk.")]
                public bool BezplatnyJakoBezskładkowy {
                    get { return bezplatnyJakoBezskładkowy; }
                    set {
                        bezplatnyJakoBezskładkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaElementu zajęcieKomornicze;
                [Priority(30)]
                [Caption("Nazwa zaj.komornicz.")]
                public DefinicjaElementu ZajęcieKomornicze {
                    get { return zajęcieKomornicze; }
                    set {
                        zajęcieKomornicze = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListZajęcieKomornicze() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }
                
                DefinicjaNieobecnosci urlopOjcowski;
                [Priority(40)]
                [Caption("Urlop ojcowski")]
                public DefinicjaNieobecnosci UrlopOjcowski {
                    get { return urlopOjcowski; }
                    set {
                        urlopOjcowski = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListUrlopOjcowski() {
                    return DefNieobecnosci.AktywneDefinicje(this);
                }

                bool pelneStanowisko = false;
                [Priority(50)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaNieobecnosci[] urlopMacierzynski;
                [Priority(60)]
                [Caption("Urlop wych(zas.macierz)")]
                public DefinicjaNieobecnosci[] UrlopMacierzynski {
                    get { return urlopMacierzynski; }
                    set {
                        urlopMacierzynski = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListUrlopMacierzynski() {
                    return DefNieobecnosci.AktywneDefinicje(this);
                }

                bool wypoczynkowyZDodatkowym = false;
                [Priority(70)]
                [Caption("Url.dod. z url.wyp.")]
                public bool WypoczynkowyZDodatkowym {
                    get { return wypoczynkowyZDodatkowym; }
                    set {
                        wypoczynkowyZDodatkowym = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool objasnienia = true;
                [Priority(80)]
                [Caption("Objaśnienia punktów")]
                public bool Objasnienia {
                    get { return objasnienia; }
                    set {
                        objasnienia = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool pkt49 = true;
                [Priority(95)]
                [Caption("Pkt 6.9 szczegółowo")]
                public bool Pkt49 {
                    get { return pkt49; }
                    set {
                        pkt49 = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool pkt51 = false;
                [Priority(90)]
                [Caption("Pkt 6.1 Ekwiwalent")]
                public bool Pkt51 {
                    get { return pkt51; }
                    set {
                        pkt51 = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaElementu odprawa;
                [Priority(100)]
                [Caption("Odprawa emer-rent")]
                public DefinicjaElementu Odprawa {
                    get { return odprawa; }
                    set {
                        odprawa = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListOdprawa() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }

                DefinicjaElementu ekwiwalentUrlop;
                [Priority(110)]
                [Caption("Ekwiwalent za urlop")]
                public DefinicjaElementu EkwiwalentUrlop {
                    get { return ekwiwalentUrlop; }
                    set {
                        ekwiwalentUrlop = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListEkwiwalentUrlop() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }

                DefinicjaElementu ekwiwalentUrlopDodatkowy;
                [Priority(120)]
                [Caption("Ekwiwalent za url.dod.")]
                public DefinicjaElementu EkwiwalentUrlopDodatkowy {
                    get { return ekwiwalentUrlopDodatkowy; }
                    set {
                        ekwiwalentUrlopDodatkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListEkwiwalentUrlopDodatkowy() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }
            }

            [SettingsContext]
            public StaticParams StaticPars {
                set {
                    odprawa = value.Odprawa;
                    zajęcieKomornicze = value.ZajęcieKomornicze;
                    urlopOjcowski = value.UrlopOjcowski;
                    urlopMacierzynski = value.UrlopMacierzynski;
                    ekwiwalentUrlop = value.EkwiwalentUrlop;
                    ekwiwalentUrlopDodatkowy = value.EkwiwalentUrlopDodatkowy;
                    wychowJakoBezskładkowy = value.WychowJakoBezskładkowy;
                    bezplatnyJakoBezskładkowy = value.BezplatnyJakoBezskładkowy;
                    pelneStanowisko = value.PelneStanowisko;
                    wypoczynkowyZDodatkowym = value.WypoczynkowyZDodatkowym;
                    objasnienia = value.Objasnienia;
                    pkt49 = value.Pkt49;
                    pkt51 = value.Pkt51;
                }
            }

            DefinicjaElementu odprawa = null;
            DefinicjaElementu zajęcieKomornicze = null;
            DefinicjaNieobecnosci urlopOjcowski = null;
            DefinicjaNieobecnosci[] urlopMacierzynski = null;
            DefinicjaElementu ekwiwalentUrlop = null;
            DefinicjaElementu ekwiwalentUrlopDodatkowy = null;
            bool wychowJakoBezskładkowy = false;
            bool bezplatnyJakoBezskładkowy = false;
            bool pelneStanowisko = false;
            bool wypoczynkowyZDodatkowym = false;
            bool objasnienia = true;
            bool pkt49 = true;
            bool pkt51 = false;
            static readonly string dots = "nie dotyczy";

            public class _Info : ContextBase {
                public _Info(Context context) : base(context) {
                    naDzien = ((ActualDate)context[typeof(ActualDate)]).Actual;
                }

                Date naDzien;
                [Priority(1)]
                [Caption("Na dzień")]
                public Date NaDzien {
                    get { return naDzien; }
                    set {
                        naDzien = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                
                int iloscKopii = 1;
                [Priority(2)]
                [Caption("Ilość kopii")]
                public int IloscKopii {
                    get { return iloscKopii; }
                    set {
                        if (value <= 0)
                            value = 1;
                        iloscKopii = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool osobno = true;
                [Priority(3)]
                [Caption("Osobne okresy (pkt 1)")]
                public bool Osobno {
                    get { return osobno; }
                    set {
                        osobno = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            _Info info;
            [Context]
            public _Info Info {
                set { info = value; }
            }
                     
    /*
    W urlopie wypoczynkowym uwzględniamy:
    Wszystkie urlopy z aktualnego roku kalendarzowego
		minus przeniesienie na 1 stycznia (o ile jest tam limit)
		minus ekwiwialeny za czas urlopu (ponad przeniesienie na 1 stycznia)*/

    class OkresyNieobecnosci {
        string okres;
        public string Okres {
            get { return okres; }
            set { okres = value; }
        }
        string nazwa;
        public string Nazwa {
            get { return nazwa; }
            set { nazwa = value; }
        }
    }

    bool GetUrlopMacierzynski(DefinicjaNieobecnosci def) {
        foreach (DefinicjaNieobecnosci dn in urlopMacierzynski)
            if (dn == def) return true;
        return false;
    }
    
    string GetNazwa(OkresNieobecności n) {
        string nazwa = string.Empty;
        if (n != null)
            nazwa = (n.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopWychowawczy ||
                GetUrlopMacierzynski(n.Definicja) ? "Urlop wychowawczy" : n.Definicja.Nazwa) +
                (n.Definicja.Guid == new Guid("00000000-0006-0005-0030-000000000000") ? " - " +
                CaptionAttribute.EnumToString(n.Zwolnienie.Przyczyna) : "");
        return nazwa;
    }

    string koniec = "nadal";
	string head = "<table cellSpacing='0' cellpadding='0' width='100%' columns='4' style='font-size: 9pt; font-family: tahoma; text-align:justify; border-style: 0px solid;'><tbody>{0}</tbody></table>";
    string row = "<tr><td width='20px' valign='top' align='{0}' style='BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid'>{1}</td>" +
        "<td width='120px' valign='top' align='{0}' style='BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid'>{2}</td>" +
		"<td width='120px' valign='top' align='{0}' style='BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid'>{3}</td>" +
		"<td valign='top' align='{0}' style='BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid'>{4}</td></tr>";
    
    void OnContextLoad(Object sender, EventArgs args) {
        PracHistoria historia = (PracHistoria)dc[typeof(PracHistoria)];
        Pracownik pracownik = historia.Pracownik;
        report = ReportHeader1;
        labelMiejscowosc.EditValue = GetMiejscowosc(historia);
        labelData.EditValue = info.NaDzien.ToString();
            
        FromTo okresZatrudnienia = historia.Etat.OkresZatrudnienia;
        
        KadryModule module = KadryModule.GetInstance(dc);
        sadpracy.EditValue = module.Config.Wydruki.SądPracy.Length > 0 ?
            module.Config.Wydruki.SądPracy : "Sądu Rejonowego - Sądu Pracy w ..............................";
            
        string last = "";
        string s = "", f = "";
        Date data = Date.Empty;
        Periods okresy = Periods.Empty;
        ArrayList firmy = new ArrayList();
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            if (last != GetStanowisko(ph)) {
                last = GetStanowisko(ph);
                if (s == "")
                    s = "<strong><LI>" + last;
                else {
                    s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong><LI><strong>"+last;
                    okresy = Periods.Empty;
                }
            }
            okresy += ph.Etat.EfektywnyOkres;
            if (data == Date.Empty)
                data = ph.Etat.Okres.From;
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty && ph.Etat.DataPrzejeciaPracownika != data && ph.Etat.EfektywnyOkres.Contains(ph.Etat.DataPrzejeciaPracownika)) {
                if (info.Osobno)
                    f = string.Format("<strong>{0}</strong> (przejście w trybie art. 23' KP)",
                        ph.Etat.PoprzedniPracodawca);
                else
                    f = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong> (przejście w trybie art. 23' KP)",
                        ph.Etat.PoprzedniPracodawca,
                        data,
                        ph.Etat.DataPrzejeciaPracownika.AddDays(-1));
                firmy.Add(new DictionaryEntry(new FromTo(data, ph.Etat.DataPrzejeciaPracownika.AddDays(-1)), f));
                data = ph.Etat.DataPrzejeciaPracownika;
            }
        }
        if (firmy.Count > 0) {
            if (info.Osobno)
                f = string.Format("<strong>{0}</strong>",
                    DaneFirmy(historia));
            else
                f = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                    DaneFirmy(historia),
                    data,
                    (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));
                firmy.Add(new DictionaryEntry(new FromTo(data, okresZatrudnienia.To), f));
        }
        else {
            if (info.Osobno)
                f = string.Format("<strong>{0}</strong>",
                    DaneFirmy(historia));
            else
                f = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                    DaneFirmy(historia),
                    okresZatrudnienia.From,
                    (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));
            firmy.Add(new DictionaryEntry(okresZatrudnienia, f));
        }
    
        if (okresy != Periods.Empty)
            s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong>";
        
        ArrayList wymiary = new ArrayList();
        Fraction currw = Fraction.Zero;
        Fraction lastw = Fraction.Zero;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            FromTo efektywny = ph.Etat.EfektywnyOkres;
            ZbiegPracyIRodzicielstwa zpr = (efektywny.To != Date.MaxValue) ? (ZbiegPracyIRodzicielstwa)pracownik.ZbiegiPracyIRodzicielstwa[efektywny.To] : null;
            currw = (zpr != null) ? zpr.WymiarEtatu : ph.Etat.Wymiar;
            if ((info.Osobno && efektywny.From == ph.Etat.Okres.From) || lastw != currw)
                wymiary.Add(new DictionaryEntry(currw, efektywny));
            else if (wymiary.Count != 0) {
                DictionaryEntry de = (DictionaryEntry)wymiary[wymiary.Count - 1];
                de.Value = new FromTo(((FromTo)de.Value).From, efektywny.To);
                wymiary[wymiary.Count - 1] = de;
            }
            lastw = currw;
        }
        
        if (info.Osobno) {
            string ss = "";
            foreach (DictionaryEntry de in firmy) {
                ss += de.Value;
                foreach (DictionaryEntry dde in wymiary) {
                    FromTo ft = (FromTo)de.Key;
                    FromTo pe = (FromTo)dde.Value;
                    if (!ft.IsIntersected(pe))
                        continue;
                    ss += "<li>w okresie od <strong>" + pe.From + "</strong> do <strong>" + (pe.To != Date.MaxValue ? pe.To.ToString() : koniec) + "</strong> w wymiarze <strong>" + (Fraction)dde.Key + "</strong></li>";
                }
            }
            labelZatrudnienie.EditValue = string.Format("{0}", ss);
        }
        else {
            string firma = "";
            foreach (DictionaryEntry de in firmy)
                firma += (firma != "" ? "<br/>" : "") + de.Value;
            string wymiar = "";
            if (wymiary.Count < 2)
                wymiar = "<strong>" + currw + "</strong> etatu.<br/>";
            else {
                string ss = "";
                foreach (DictionaryEntry de in wymiary) {
                    FromTo pe = (FromTo)de.Value;
                    ss += "<li><strong>" + (Fraction)de.Key + "</strong> etatu od <strong>" + pe.From + "</strong> do <strong>" + (pe.To != Date.MaxValue ? pe.To.ToString() : koniec) + "</strong></li>";
                }
                wymiar = ss;
            }
            labelZatrudnienie.EditValue = string.Format("{0}<br/>w wymiarze: {1}", firma, wymiar);
        }

        labelStanowisko.EditValue = s;
        if (historia.Etat.RozwiazanieUmowy.PrzyczynaRozwUmowy != null) {
            string str = historia.Etat.RozwiazanieUmowy.PrzyczynaRozwUmowyOpis;
            if (string.IsNullOrEmpty(str))
                str = historia.Etat.RozwiazanieUmowy.PrzyczynaRozwUmowy.Nazwa;
            str = str.Replace(".1.KP", "<sup>1</sup> KP");
            str = str.Replace(".2.KP", "<sup>2</sup> KP");
            str = str.Replace(".3.KP", "<sup>3</sup> KP");
            str = str.Replace(".4.KP", "<sup>4</sup> KP");
            switch (historia.Etat.RozwiazanieUmowy.PrzyczynaRozwUmowy.Typ) {
                case TypPrzyczynyRozwUmowy.Rozwiązanie:
                    labelPrzyczyna1.EditValue = "<li>" + str;
                    break;
                case TypPrzyczynyRozwUmowy.Wygaśnięcie:
                    labelPrzyczyna2.EditValue = "<li>" + str;
                    break;
            }
        }
            
        FromTo okres = historia.Etat.Okres.To != Date.MaxValue ? FromTo.Year(historia.Etat.Okres.To.Year) * okresZatrudnienia : okresZatrudnienia;

        Dictionary<CzlonekRodziny, Periods> ojc = new Dictionary<CzlonekRodziny, Periods>();
        Dictionary<CzlonekRodziny, Periods> rodz = new Dictionary<CzlonekRodziny, Periods>();
        Dictionary<CzlonekRodziny, Periods> wych = new Dictionary<CzlonekRodziny, Periods>();
        Periods dniNieWyn = Periods.Empty;
        CzlonekRodziny dziecko = null;
        Periods mac = Periods.Empty;
        bool result;
        Periods ps;

        bool op188cz = false;
        int op188 = 0;
        Time op188T = Time.Zero;
        Periods sw = Periods.Empty;
        Time wyp = Time.Zero;
        Time wyp167 = Time.Zero;
        int dni167 = 0;
        Time dod = Time.Zero;
        bool wch;
                
        ArrayList okresyBezpłatne = new ArrayList();
        foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okresZatrudnienia, true)) {
            wch = false;
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                    if (n.Definicja.Guid != new Guid("00000000-0006-0005-0008-000000000000")) {
                        OkresyNieobecnosci on = new OkresyNieobecnosci();
                        on.Okres = n.Okres.ToString();
                        on.Nazwa = n.Definicja.Nazwa;
                        okresyBezpłatne.Add(on);
                    }
                    break;
                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    wch = true;
                    break;
                case PrzyczynaNieobecnosci.UrlopRodzicielski:
                    result = true;
                    CzlonekRodziny cr = dziecko;
                    dziecko = ((Nieobecnosc)n).CzlonekRodziny;
                    if (dziecko==null) {
                        if (cr==null || !string.IsNullOrEmpty(cr.Imie) || (rodz.ContainsKey(cr) && rodz[cr].To+1!=n.Okres.From))
                            dziecko = new CzlonekRodziny(pracownik);
                        else
                            dziecko = cr;
                    }
                    else
                        if (dziecko.Urodzony.Data!=Date.Empty && okresZatrudnienia.To!=Date.MaxValue && dziecko.Urodzony.Data.AddYears(1).FirstDayYear()<=okresZatrudnienia.To.LastDayYear()) {
                            StazPracy sp = new StazPracy(new FromTo(dziecko.Urodzony.Data.AddYears(1).FirstDayYear(), okresZatrudnienia.To.LastDayYear()));
                            sp = sp.Normalizuj();
                            result = sp.Lata < 6;
                        }
                    if (result) {
                        if (!rodz.TryGetValue(dziecko, out ps))
                            rodz.Add(dziecko, n.Okres.ToPeriods());
                        else
                            rodz[dziecko] += n.Okres;
                    }
                    break;
                case PrzyczynaNieobecnosci.SłużbaWojskowa:
                    sw += n.Okres;
                    break;
                default:
                    if (n.Definicja == urlopOjcowski) {          //TID: 8461
                        result = true;
                        dziecko = ((Nieobecnosc)n).CzlonekRodziny;
                        if (dziecko==null)
                            dziecko = new CzlonekRodziny(pracownik);
                        else
                            if (dziecko.Urodzony.Data!=Date.Empty && okresZatrudnienia.To!=Date.MaxValue && dziecko.Urodzony.Data<=okresZatrudnienia.To) {
                                StazPracy sp = new StazPracy(new FromTo(dziecko.Urodzony.Data, okresZatrudnienia.To));
                                sp = sp.Normalizuj();
                                result = sp.Lata < 2;
                            }
                        if (result) {
                            if (!ojc.TryGetValue(dziecko, out ps))
                                ojc.Add(dziecko, n.Okres.ToPeriods());
                            else
                                ojc[dziecko] += n.Okres;
                        }
                    }
                    else if (GetUrlopMacierzynski(n.Definicja))
                        wch = true;
                    if (n.Definicja.Przyczyna==PrzyczynaNieobecnosci.UrlopMacierzyński)
                        mac += n.Okres;
                    break;
            }
            if (wch) {
                result = true;
                dziecko = ((Nieobecnosc)n).CzlonekRodziny;
                if (dziecko==null)
                    dziecko = new CzlonekRodziny(pracownik);
                else
                    if (dziecko.Urodzony.Data!=Date.Empty && okresZatrudnienia.To!=Date.MaxValue && dziecko.Urodzony.Data<=okresZatrudnienia.To) {
                        StazPracy sp = StazPracy.Empty;
                        KodRSA rsa = n.Definicja.KodRSA;
                        if (rsa.Kod==121) {
                            if (dziecko.Urodzony.Data.AddYears(1).FirstDayYear()<=okresZatrudnienia.To.LastDayYear())
                                sp = new StazPracy(new FromTo(dziecko.Urodzony.Data.AddYears(1).FirstDayYear(), okresZatrudnienia.To.LastDayYear()));
                        }
                        else
                            sp = new StazPracy(new FromTo(dziecko.Urodzony.Data, okresZatrudnienia.To));
                        sp = sp.Normalizuj();
                        result = (rsa.Kod==121) ? sp.Lata < 6 : sp.Lata < 18;
                    }
                if (result) {
                    if (!wych.TryGetValue(dziecko, out ps))
                        wych.Add(dziecko, n.Okres.ToPeriods());
                    else
                        wych[dziecko] += n.Okres;
                }
            }
        }

        if (okresyBezpłatne.Count == 0)
            urlopbezplatny.EditValue = dots;
        else {
            int num = 1;
            string rows = string.Format(row, "center", "<b>Lp</b>", "<b>Okres<br/>Od</b>", "<b>Okres<br/>Do</b>", "<b>Nazwa okresu</b>");
            foreach (OkresyNieobecnosci on in okresyBezpłatne) {
                FromTo okr = FromTo.Parse(on.Okres);
                rows += string.Format(row, "right", num++, okr.From, okr.To, on.Nazwa);
            }
            urlopbezplatny.EditValue = string.Format(head, rows);
        }

        foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okres, true)) {
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    break;
                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    break;
                case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
                    if (n.Urlop.Przyczyna == PrzyczynaUrlopu.NaŻądanie) {
                        CzasDni cd = n.Norma(n.Okres);
                        wyp167 += cd.Czas;
                        dni167 += cd.Dni;
                    }
                    else
                        wyp += n.Norma(n.Okres).Czas;
                    break;
                default:
                    if (n.Definicja != urlopOjcowski) {
                        DefinicjaLimitu l = n.Definicja.Limit;
                        if (l != null)
                            if (l.Guid == new Guid("00000000-0006-0004-0003-000000000000"))
                                { op188 += n.Norma(n.Okres).Dni; op188cz = false; }
                            else if (l.Guid == new Guid("00000000-0006-0004-0005-000000000000"))
                                { op188T += n.Norma(n.Okres).Czas; op188cz = true; }
                            else if (l.Guid == DefinicjaLimitu.UrlopDodatkowy)
                                dod += n.Norma(n.Okres).Czas;
                    }
                    break;
            }
        }

        Periods okresyWyczekiwania = Periods.Empty;
        try {
            foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                if (e.Definicja.Guid == DefinicjaElementu.WynagrChoroboweZerowe) {
                    if (e.RodzajZrodla == RodzajŹródłaWypłaty.Storno)
                        dniNieWyn -= e.Okres;
                    else
                        dniNieWyn += e.Okres;
                }
                else if (e.Definicja.Guid == DefinicjaElementu.OkresWyczekiwania) {
                    bool ow = true;
                    WypElementNieobecność en = (WypElementNieobecność)e;
                    foreach (WypElement we in en.Nieobecność.Elementy)
                        if (we != e && we.Okres == e.Okres && we.Definicja.Guid != DefinicjaElementu.OkresWyczekiwania) {
                            ow = false;
                            break;
                        }
                    if (ow) {
                        if (e.RodzajZrodla == RodzajŹródłaWypłaty.Storno)
                            okresyWyczekiwania -= e.Okres;
                        else
                            okresyWyczekiwania += e.Okres;
                    }
                }
        }
        catch { Msg(); }
        okresyWyczekiwania = okresyWyczekiwania.ToFlat();

        string currNazwa = string.Empty;
        string prevNazwa = string.Empty;
        FromTo prevOkr = FromTo.Empty;
        OkresNieobecności prevDef = null;
        ArrayList okresyNieskładkowe = new ArrayList();
        Periods okresyZatrudnienia = (Periods.New(okresZatrudnienia) - okresyWyczekiwania).ToFlat();
        foreach (FromTo okrzatr in okresyZatrudnienia)
            foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okrzatr, true)) {
                currNazwa = GetNazwa(n);
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:        //TID: 8565
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                        //TID: 5982
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        //TID: 8565
                        if ((n.Definicja.Przyczyna != PrzyczynaNieobecnosci.UrlopWychowawczy || wychowJakoBezskładkowy) &&
                            (n.Definicja.Guid != new Guid("00000000-0006-0005-0018-000000000000") || bezplatnyJakoBezskładkowy)) {
                            if (prevDef != null && prevNazwa == currNazwa &&
                                prevDef.Zwolnienie.Przyczyna == n.Zwolnienie.Przyczyna &&
                                prevOkr.To + 1 == n.Okres.From)
                                prevOkr = new FromTo(prevOkr.From, n.Okres.To);
                            else {
                                if (prevDef != null) {
                                    OkresyNieobecnosci on = new OkresyNieobecnosci();
                                    on.Okres = prevOkr.ToString();
                                    on.Nazwa = GetNazwa(prevDef);
                                    okresyNieskładkowe.Add(on);
                                }
                                prevNazwa = GetNazwa(n);
                                prevOkr = n.Okres;
                                prevDef = n;
                            }
                        }
                        break;
                    default:
                        if (GetUrlopMacierzynski(n.Definicja) && wychowJakoBezskładkowy) {
                            if (prevDef != null && prevNazwa == currNazwa &&
                                prevDef.Zwolnienie.Przyczyna == n.Zwolnienie.Przyczyna &&
                                prevOkr.To + 1 == n.Okres.From)
                                prevOkr = new FromTo(prevOkr.From, n.Okres.To);
                            else {
                                if (prevDef != null) {
                                    OkresyNieobecnosci on = new OkresyNieobecnosci();
                                    on.Okres = prevOkr.ToString();
                                    on.Nazwa = GetNazwa(prevDef);
                                    okresyNieskładkowe.Add(on);
                                }
                                prevNazwa = GetNazwa(n);
                                prevOkr = n.Okres;
                                prevDef = n;
                            }
                        }
                        break;
                }
            }

        if (prevDef != null) {
            OkresyNieobecnosci on = new OkresyNieobecnosci();
            on.Okres = prevOkr.ToString();
            on.Nazwa = GetNazwa(prevDef);
            okresyNieskładkowe.Add(on);
        }

        if (okresyNieskładkowe.Count == 0) {
            okresyNS.EditValue = "<strong>0</strong> dni";
            if (!objasnienia) for (int i=0; i<90; i++) okresyNS.EditValue += "&nbsp;";
        }
        else {
            int num = 1;
            string rows = string.Format(row, "center", "<b>Lp</b>", "<b>Okres nieskładkowy<br/>Od</b>", "<b>Okres nieskładkowy<br/>Do</b>", "<b>Nazwa okresu</b>");
            foreach (OkresyNieobecnosci on in okresyNieskładkowe) {
                FromTo okr = FromTo.Parse(on.Okres);
                rows += string.Format(row, "right", num++, okr.From, okr.To, on.Nazwa);
            }
            for (int i=0; i<100; i++) okresyNS.EditValue += "&nbsp;";
            okresyNS.EditValue += string.Format(head, rows);
        }

        Time norma = pracownik[okres.To].Etat.Kalendarz.NormaDobowa;
        if (norma==Time.Zero)
            norma = new Time(8, 0);
            
        Time przeniesWyp = WyliczPrzeniesUrlop(pracownik, okres);        
        Time ekwiwalentWyp = WyliczEkwiwalentUrlop(pracownik, okres);
        Time ekwiwalentWyp2;
        UpdateWyp(ref wyp, out ekwiwalentWyp2, przeniesWyp, ekwiwalentWyp);

        Time przeniesDod = WyliczPrzeniesDodatkowy(pracownik, okres);
        Time ekwiwalentDod = WyliczEkwiwalentDodatkowy(pracownik, okres);
        Time ekwiwalentDod2;
        UpdateWyp(ref dod, out ekwiwalentDod2, przeniesDod, ekwiwalentDod);

        if (ojc.Count==0)
            ojcowski.EditValue = dots;
        else {
            string str = "";
            foreach (CzlonekRodziny cr in ojc.Keys) {
                Date ojcPrev = Date.Empty;
                int ojcTygod = 0, ojcCzesci = 0;
                foreach (FromTo ft in ojc[cr]) {
                    ojcTygod += ft.Days;
                    if (ojcPrev==Date.Empty)
                        ojcCzesci++;
                    else if (ojcPrev+1<ft.From)
                        ojcCzesci++;
                    ojcPrev = ft.To;
                }
                ojcTygod = ojcTygod / 7;
                int ilosc = ojcTygod - (ojcTygod/10*10);
                string str1 = ojcTygod==1 ? "tydzień" : (ojcTygod<5 ? "tygodnie" : (ojcTygod<20 ? "tygodni" : (ilosc<2 || ilosc>4 ? "tygodni" : "tygodnie")));
                string str2 = ojcCzesci==1 ? "części" : "częściach";
                string str3 = ". . . . . . . . . . . . . . . . . . . .";
                if (!string.IsNullOrEmpty(cr.Imie)) {
                    str3 = string.Format("{0} {1}", cr.Nazwisko, cr.Imie);
                    foreach (CzlonekRodziny dr in pracownik.Rodzina)
                        if (cr!=dr && cr.Urodzony.Data!=Date.Empty && cr.Urodzony.Data==dr.Urodzony.Data)
                            str3 += string.Format(", {0} {1}", dr.Nazwisko, dr.Imie);
                }
                str += (str!="" ? "<br/>" : "") + string.Format("{0}</strong> {1} w <strong>{2}</strong> {3} na: <strong>{4}", ojcTygod, str1, ojcCzesci, str2, str3);
            }
            ojcowski.EditValue = "<br/>" + str;
        }
        
        if (rodz.Count==0)
            rodzicielski.EditValue = dots;
        else {
            string str = "";
            foreach (CzlonekRodziny cr in rodz.Keys) {
                bool macierz = false;
                Date rodzPrev = Date.Empty;
                int rodzTygod = 0, rodzCzesci = 0;
                int rodzTygod2 = 0, rodzCzesci2 = 0;
                foreach (FromTo ft in rodz[cr]) {
                    bool sumuj = true;    
                    foreach (FromTo ftt in mac)
                        if (ftt.To+1==ft.From) {
                            macierz = true;
                            sumuj = false;
                            break;
                        }
                    rodzTygod += ft.Days;
                    if (rodzPrev==Date.Empty)
                        rodzCzesci++;
                    else if (rodzPrev+1<ft.From)
                        rodzCzesci++;
                    if (sumuj) {
                        rodzTygod2 += ft.Days;
                        if (rodzPrev==Date.Empty)
                            rodzCzesci2++;
                        else if (rodzPrev+1<ft.From)
                            rodzCzesci2++;
                    }    
                    rodzPrev = ft.To;
                }
                rodzTygod = rodzTygod / 7;
                rodzTygod2 = rodzTygod2 / 7;
                int ilosc = rodzTygod-(rodzTygod/10*10);
                string str1 = rodzTygod==1 ? "tydzień" : (rodzTygod<5 ? "tygodnie" : (rodzTygod<20 ? "tygodni" : (ilosc<2 || ilosc>4 ? "tygodni" : "tygodnie")));
                string str2 = rodzCzesci==1 ? "części" : "częściach";
                string str3 = ". . . . . . . . . . . . . . . . . . . .";
                str += (str != "" ? "<br/>" : "") + string.Format("{0}</strong> {1} w <strong>{2}</strong> {3}<strong>", rodzTygod, str1, rodzCzesci, str2);
                if (rodzTygod2!=0) {
                    ilosc = rodzTygod2-(rodzTygod2/10*10);
                    str1 = rodzTygod2==1 ? "tydzień" : (rodzTygod2<5 ? "tygodnie" : (rodzTygod2<20 ? "tygodni" : (ilosc<2 || ilosc>4 ? "tygodni" : "tygodnie")));
                    str2 = rodzCzesci2==1 ? "części" : "częściach";
                    string str01 = rodzCzesci2.ToString();
                    string str02 = rodzTygod2.ToString();
                    if (!string.IsNullOrEmpty(cr.Imie)) {
                        str3 = string.Format("{0} {1}", cr.Nazwisko, cr.Imie);
                        foreach (CzlonekRodziny dr in pracownik.Rodzina)
                            if (cr!=dr && cr.Urodzony.Data!=Date.Empty && cr.Urodzony.Data==dr.Urodzony.Data)
                                str3 += string.Format(", {0} {1}", dr.Nazwisko, dr.Imie);
                    }
                    else
                        str01 = str02 = ". . . . . .";
                    str += (str!="" ? ", " : "") + string.Format("</strong>w tym na podstawie art. 182<sup>1c</sup> § 3 Kodeksu pracy w <strong>{0}</strong> {1} (<strong>{2}</strong> {3}), na: <strong>{4}", str01, str2, str02, str1, str3);
                }
                else if (macierz || string.IsNullOrEmpty(cr.Imie)) {
                    string str0 = ". . . . . .";
                    str1 = "tygodni";
                    str2 = "części";
                    if (!string.IsNullOrEmpty(cr.Imie)) {
                        str3 = string.Format("{0} {1}", cr.Nazwisko, cr.Imie);
                        foreach (CzlonekRodziny dr in pracownik.Rodzina)
                            if (cr!=dr && cr.Urodzony.Data!=Date.Empty && cr.Urodzony.Data==dr.Urodzony.Data)
                                str3 += string.Format(", {0} {1}", dr.Nazwisko, dr.Imie);
                    }
                    str += (str!="" ? ", " : "") + string.Format("</strong>w tym na podstawie art. 182<sup>1c</sup> § 3 Kodeksu pracy w <strong>{0}</strong> {1} (<strong>{2}</strong> {3}), na: <strong>{4}", str0, str2, str0, str1, str3);
                }
            }
            rodzicielski.EditValue = "<br/>" + str;
        }

        if (wych.Count==0)
            wychowawczy.EditValue = dots;
        else {
            string str = "";
            foreach (CzlonekRodziny cr in wych.Keys) {
                Date wychPrev = Date.Empty;
                int wychDni = 0, wychCzesci = 0;
                foreach (FromTo ft in wych[cr]) {
                    wychDni += ft.Days;
                    if (wychPrev==Date.Empty)
                        wychCzesci++;
                    else if (wychPrev+1<ft.From)
                        wychCzesci++;
                    wychPrev = ft.To;
                }
                string str1 = wychDni==1 ? "dzień" : "dni";
                string str2 = wychCzesci==1 ? "części" : "częściach";
                string str3 = ". . . . . . . . . . . . . . . . . . . .";
                if (!string.IsNullOrEmpty(cr.Imie)) {
                    str3 = string.Format("{0} {1}", cr.Nazwisko, cr.Imie);
                    foreach (CzlonekRodziny dr in pracownik.Rodzina)
                        if (cr!=dr && cr.Urodzony.Data!=Date.Empty && cr.Urodzony.Data==dr.Urodzony.Data)
                            str3 += string.Format(", {0} {1}", dr.Nazwisko, dr.Imie);
                }
                str += (str != "" ? "<br/>" : "") + string.Format("{0}</strong> {1} w okresie (okresach) <strong>{2}</strong> w <strong>{3}</strong> {4} na: <strong>{5}", wychDni, str1, wych[cr].ToFlat().ToString("c"), wychCzesci, str2, str3);
            }
            wychowawczy.EditValue = "<br/>" + str + "<br/>";
        }
                
        ochronny.EditValue = dots;
        opieka188.EditValue = (op188cz ? op188T + " </strong>godz." : op188 + " </strong>dni");
        opieka188opis.EditValue = "(liczba " + (op188cz ? "godz." : "dni") + " zwolnienia wykorzystanego w roku kalendarzowym, w którym ustał stosunek pracy)";

        int dniWyp = Dni(wyp + wyp167, norma);
        //TID: 8353
        if (dniWyp < dni167) {
            wypoczynkowy.EditValue = dni167 + (wypoczynkowyZDodatkowym ? Dni(dod, norma) : 0);
            wypoczynkowyT.EditValue = "";
        }
        else {
            wypoczynkowy.EditValue = dniWyp + (wypoczynkowyZDodatkowym ? Dni(dod, norma) : 0);
            wypoczynkowyT.EditValue = Godz(wyp + wyp167, norma);
        }
        wypoczynkowyG.EditValue = wyp + wyp167 + (wypoczynkowyZDodatkowym ? dod : Time.Zero);
        ekwiwalentG.EditValue = pkt51 ? (", w tym <strong>" + (ekwiwalentWyp2 == Time.Zero ? "0" : ekwiwalentWyp2.ToString()) + "</strong> godz. ekwiwalentu za czas urlopu") : "";
        wypoczynkowy167.EditValue = dni167;
        wypoczynkowy167G.EditValue = wyp167;
        służba.EditValue = sw==Periods.Empty ? dots : sw.ToFlat().ToString("c");

        string szWarH = SzczególneWarunkiHist(pracownik, okresZatrudnienia);
        string szWarU = SzczególneWarunkiUbezp(pracownik, okresZatrudnienia);
		if ((szWarH.Length == 0) && (szWarU.Length == 0))
			szWarunki.EditValue = dots;
		else {
			szWarunki.EditValue = szWarH;
			if ((szWarH.Length > 0) && (szWarU.Length > 0))
				szWarunki.EditValue += ", ";
			szWarunki.EditValue += szWarU;
		}

        if ((dod == Time.Zero) && (ekwiwalentDod2==Time.Zero))
            dodUrlop.EditValue = "<strong>0</strong> dni";
        else {
            string tmp = "";
            if (pkt49) {
                if (dod != Time.Zero) {
                    tmp += "urlop dodatkowy <strong>" + Dni(dod, norma) + "</strong> dni";
                    if (ekwiwalentDod2 != Time.Zero)            //TID: 10365
                        tmp += " (w tym wypłacony ekwiwalent <strong>" + Dni(ekwiwalentDod2, norma) + "</strong> dni)";
                }
            }
            else {
                if (dod != Time.Zero)
                    tmp += "<b>udzielono dodatkowego urlopu wypoczynkowego na podstawie art. 19 ustawy z dnia 27 sierpnia 1997 r. o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych (Dz. U. z 2011 r. nr 127, poz. 721 z późn. zm.).</b>";
            }
            dodUrlop.EditValue = tmp;
        }

        if (dniNieWyn.Count == 0)
            nieWyn.EditValue = dots;
        else {
            string ss = "";
            foreach (FromTo odn in dniNieWyn) {
                if (ss != "")
                    ss += ", ";
                if (odn.Days == 1)
                    ss += odn.From;
                else
                    ss += odn;
            }
            nieWyn.EditValue = ss;
        }

        Set<string> zajęcia = new Set<string>();
        string zz = "";
        foreach (ZajęcieKomornicze zk in pracownik.ZajęciaKomornicze) {
            if (zk.SplataZakonczona || zk.Anulowane)
                continue;
            if (zk.Data > okresZatrudnienia.To ||
                (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.KwotaMiesięczna && zk.DataSplaty != Date.MaxValue))
                continue;
            decimal splata = 0;
            try {
                foreach (WypElement w in zk.Elementy)
                    if (w.Okres.From <= okresZatrudnienia.To)
                        splata += -w.Wartosc;
            }
            catch { Msg(); }
            if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota && zk.Kwota <= splata)
                continue;
            if (zk.Rozliczenie.Odbiorca == null)
                throw new Exception(string.Format("W zajęciu wynagrodzenia nr: {0} brak uzupełnionego pola Komornik", zk.NumerSprawy));
            string zks = zk.Rozliczenie.Odbiorca.Nazwa;
            if (zk.NumerSprawy.Length > 0)
                zks += ", ";
            zks += "<strong>" + zk.NumerSprawy + "</strong>";
            zks += ", wysokość potrąconych już kwot: <strong>" + splata + "</strong>";
            zajęcia.Add(zks);
        }
        if (zajęcieKomornicze != null) {
            decimal we = 0;
            try {
                foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                    if (e.Definicja == zajęcieKomornicze)
                        we += System.Math.Abs(e.Wartosc);                
            }
            catch { Msg(); }
            if (we != 0) {
                string zks = zajęcieKomornicze.Nazwa + ", <strong>" + we + "</strong>";
                zajęcia.Add(zks);
            }
        }        
        foreach (string z in zajęcia)
            zz += "<li>" + z + "</li>";
        komornik.EditValue = zz == "" ? "<strong>" + dots + "</strong>" : zz;
        if (!objasnienia && zz == "") for (int i=0; i<70; i++) komornik.EditValue += "&nbsp;";

        if (odprawa != null) {
            try {
                foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                    if (e.Definicja == odprawa) {
                        dodUrlop.EditValue += "<br/><li><b>wypłacono odprawę emerytalno-rentową przewidzianą w art. 92<sup>1</sup> K.p</b></li>";
                        break;
                    }
            }
            catch { Msg(); }
        }        
        
        double pozostDni = 0;
        Time pozostGodz = Time.Zero;
        if (ekwiwalentWyp == Time.Zero) 
            WyliczPozostalo(pracownik, okres, ref pozostDni, ref pozostGodz);
        if (pozostDni > 0 || pozostGodz > Time.Zero)
            dodatkowe.EditValue = string.Format("</strong>Strony skorzystały z możliwości wynikającej z art. 171 § 3 KP i postanowiły" +
                " o wykorzystaniu <strong>{0}</strong> dni (<strong>{1}</strong> godz.) urlopu wypoczynkowego w czasie kolejnego zawartego miedzy nimi stosunku pracy.",
                pozostDni, pozostGodz);
        else {
            dodatkowe.EditValue = dots;
            for (int i=0; i<90; i++) dodatkowe.EditValue += "&nbsp;";
        }

        var ww = new OkresWypowiedzeniaBaseWorker._PracHistoria.OkresWypowiedzeniaWorker();
        ww.Historia = historia;
        ww.DataAktualności = historia.Etat.OkresWypowiedzenia.DataZlozenia;
        if (ww.DataAktualności == Date.Empty) ww.DataAktualności = Date.Today;
        if (historia.Etat.RozwiazanieUmowy.ZaOdszkodowaniem && historia.Etat.OkresWypowiedzenia.Skrocony && ww.Upływa>historia.Etat.Okres.To)
            skrOkres.EditValue = new FromTo(historia.Etat.Okres.To+1, ww.Upływa);
        else
            skrOkres.EditValue = dots;
    
        PlaceModule płace = PlaceModule.GetInstance(pracownik);
        SubTable es = new SubTable(płace.WypElementy.WgPracownik[pracownik], okres);
    
        int wyn92 = 0;
        List<FromTo> wyn92ft = new List<FromTo>();
        foreach (WypElement element in es) {
            try {
                if (!wyn92ft.Contains(element.Okres) || element is WypElementStorno)
                    if (!element.RozliczenieStorna && !element.KorektaWyrokTK) {
                        KodRSA rsa = element.KodRSA;
                        if (rsa != null && rsa.WynagrodzenieChorobowe) {
                            WypSkladnikGłówny sg = element.SkładnikGłówny;
                            if (sg != null) {
                                wyn92 += sg.Dni;
                                if (element is WypElementStorno)
                                    wyn92ft.Remove(element.Okres);
                                else
                                    wyn92ft.Add(element.Okres);
                            }
                        }
                    }
            }
            catch { Msg(); }
        }
    
        wynagrodz92.EditValue = wyn92;

        labelPracodawcy.EditValue = dots;

        desc1.Visible = desc2.Visible = desc3.Visible = desc4.Visible = desc5.Visible = desc6.Visible = desc8.Visible =
            desc9.Visible = desc10.Visible = desc11.Visible = desc12.Visible = desc13.Visible = desc14.Visible =
            desc15.Visible = desc16.Visible = objasnienia;

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(historia);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (pelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
    
    string DaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        string regon = core.Config.Firma.Pieczątka.REGON;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
        }
        PieczątkaREGON.EditValue = regon;

        return nazwa;
    }
    
            string SzczególneWarunkiHist(Pracownik pracownik, FromTo okresZatrudnienia) {
                string result = "";
                FromTo okres = FromTo.Empty;
                string stanowisko = "";
				string kod = "";
                
                foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia))
                    if (ph.PracaWSzczWarunkach.KodStr != "" || ph.PracaWSzczWarunkach.Opis != "") {
                        FromTo o = ph.PracaWSzczWarunkach.OkresExt * ph.Etat.EfektywnyOkres;
                        if (o != FromTo.Empty) {
                            if (okres.To + 1 == o.From && stanowisko == GetStanowisko(ph))
                                okres = new FromTo(okres.From, o.To);
                            else {
                                if (okres != FromTo.Empty) {
                                    Periods ps = okres.ToPeriods();
                                    foreach (INieobecnosc nie in pracownik.Czasy.Nieobecnosci(okres, true))
                                        if (nie.Definicja.PrzerwaSzWarunkiSzCharakter)
                                            ps -= nie.Okres;
                                    foreach (FromTo ft in ps)
                                        result += ((result != "") ? ", " : "") + ft;
                                    if (ps != Periods.Empty)
                                        result += " (" + kod + ", " + stanowisko + ")";
                                }
                                okres = o;
								kod = ph.PracaWSzczWarunkach.KodStr != "" ? ph.PracaWSzczWarunkach.KodStr : ph.PracaWSzczWarunkach.Opis;
                                stanowisko = GetStanowisko(ph);
                            }
                        }
                    }
                
                if (okres != FromTo.Empty) {
                    Periods ps = okres.ToPeriods();
                    foreach (INieobecnosc nie in pracownik.Czasy.Nieobecnosci(okres, true))
                        if (nie.Definicja.PrzerwaSzWarunkiSzCharakter)
                            ps -= nie.Okres;
                    foreach (FromTo ft in ps)
                        result += ((result != "") ? ", " : "") + ft;
                    if (ps != Periods.Empty)
                        result += " (" + kod + ", " + stanowisko + ")";
                }

                return result;
            }

            string SzczególneWarunkiUbezp(Pracownik pracownik, FromTo okresZatrudnienia) {
                string result = "";
                FromTo okres = FromTo.Empty;
                string stanowisko = "";
                string kod = "";
                                
                foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia))
                    if (ph.PracaWSzczWarunkach2009.Kod != null) {
                        FromTo o = ph.PracaWSzczWarunkach2009.Okres * ph.Etat.EfektywnyOkres;
                        if (o != FromTo.Empty) {
                            if (okres.To + 1 == o.From && stanowisko == GetStanowisko(ph))
                                okres = new FromTo(okres.From, o.To);
                            else {
                                if (okres != FromTo.Empty) {
                                    Periods ps = okres.ToPeriods();
                                    foreach (INieobecnosc nie in pracownik.Czasy.Nieobecnosci(okres, true))
                                        if (nie.Definicja.PrzerwaSzWarunkiSzCharakter)
                                            ps -= nie.Okres;
                                    foreach (FromTo ft in ps)
                                        result += ((result != "") ? ", " : "") + ft;
                                    if (ps != Periods.Empty)
                                        result += " (" + kod + ", " + stanowisko + ")";
                                }
                                okres = o;
                                kod = ph.PracaWSzczWarunkach2009.Kod.Nazwa;
                                stanowisko = GetStanowisko(ph);
                            }
                        }
                    }

                if (okres != FromTo.Empty) {
                    Periods ps = okres.ToPeriods();
                    foreach (INieobecnosc nie in pracownik.Czasy.Nieobecnosci(okres, true))
                        if (nie.Definicja.PrzerwaSzWarunkiSzCharakter)
                            ps -= nie.Okres;
                    foreach (FromTo ft in ps)
                        result += ((result != "") ? ", " : "") + ft;
                    if (ps != Periods.Empty)
                        result += " (" + kod + ", " + stanowisko + ")";
                }

                return result;
            }
		                                                                                
            //1. Wypłacony urlop najpierw traktujemy jako zaległy, czyli
            //pomniejszamy obie te liczby o mniejszą z nich.
	//2. Wypłacony ekwiwalent traktujemy najpier jako ekwiwalent za poprzedni rok, czyli
	//pomniejszamy obie te liczby o mniejszą z nich.
	//3. Pomniejszamy urlop o to co pozostało z przeniesienia.
	//4. Powiększamy urlop o to co zostało z ekwiwalentu.
            void UpdateWyp(ref Time wyp, out Time ekwg, Time przenies, Time ekwiwalent) {
                if (przenies >= wyp) {
                    przenies -= wyp;
                    wyp = Time.Zero;
                }
                else {
                    wyp -= przenies;
                    przenies = Time.Zero;
                }

                if (przenies >= ekwiwalent) {
                    przenies -= ekwiwalent;
                    ekwiwalent = Time.Zero;
                }
                else {
                    ekwiwalent -= przenies;
                    przenies = Time.Zero;
                }

                /*if (wyp >= przenies)
                    wyp -= przenies;
                else
                    wyp = Time.Zero;*/

                wyp += ekwiwalent;
                ekwg = ekwiwalent;
            }

            Time WyliczPrzeniesUrlop(Pracownik pracownik, FromTo okres) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
                return WyliczPrzenies(pracownik, okres, def);
            }

            Time WyliczPrzeniesDodatkowy(Pracownik pracownik, FromTo okres) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopDodatkowy;
                return WyliczPrzenies(pracownik, okres, def);
            }

            Time WyliczPrzenies(Pracownik pracownik, FromTo okres, DefinicjaLimitu def) {
                if (okres.From != new Date(okres.From.Year, 1, 1))
                    return Time.Zero;

                LimitNieobecnosci limit = def[pracownik, okres.From, false];
                if (limit == null)
                    return Time.Zero;

                Time t = limit.PrzeniesienieGodz;
                return t == Time.Empty ? Time.Zero : t;
            }

            void WyliczPozostalo(Pracownik pracownik, FromTo okres, ref double dni, ref Time godz) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopWypoczynkowy;

                LimitNieobecnosci limit = def[pracownik, okres.To, false];
                if (limit == null)
                    return;

                dni = limit.PozostaloDni;
                godz = limit.PozostaloGodz;
            }
            
    Time WyliczEkwiwalentUrlop(Pracownik pracownik, FromTo okres) {
        return ekwiwalentUrlop != null ? WyliczEkwiwalent(pracownik, okres, ekwiwalentUrlop.Guid) : Time.Zero;
    }

    Time WyliczEkwiwalentDodatkowy(Pracownik pracownik, FromTo okres) {
        return ekwiwalentUrlopDodatkowy != null ? WyliczEkwiwalent(pracownik, okres, ekwiwalentUrlopDodatkowy.Guid) : Time.Zero;
    }

    Time WyliczEkwiwalent(Pracownik pracownik, FromTo okres, Guid guid) {
		Time t = Time.Zero;
		PlaceModule płace = PlaceModule.GetInstance(pracownik);
		DefinicjaElementu def = płace.DefElementow[guid];
        try {
		    foreach (WypElement e in pracownik.Elementy[okres])
			    if (e.Definicja==def && e.SkładnikGłówny!=null)
				    t += e.SkładnikGłówny.Czas;
        }
        catch { Msg(); }
		return t;				
    }
    
    int Dni(Time t, Time norma) {
		int mt = t.TotalMinutes;
		int mn = norma.TotalMinutes;
		return mt/mn;
    }
    
    string Godz(Time t, Time norma) {
		int mt = t.TotalMinutes;
		int mn = norma.TotalMinutes;
		int m = mt%mn;
		if (m==0)
			return "";
		return "i <strong>" + new Time(0, m) +"</strong> godz. ";
    }
    
    static void Msg(object v) {
    }

    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

	</script>

	<meta content="False" name="vs_showGrid">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaOPracę" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"></EA:DATACONTEXT>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Świadectwo pracy" runat="server"></cc1:reportheader>
			<table id="Table1" cellSpacing="0" width="100%" columns="1" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr>
					<td valign="top" align="right">
						<ea:datalabel id="labelMiejscowosc" runat="server"></ea:datalabel>,
						<ea:datalabel id="labelData" runat="server"></ea:datalabel>
					</td>
                </tr>
            </tbody>
            </table>
			<p></p>
			<font face="Tahoma" size="2">
				<p style="text-align:left">
					REGON:
					<ea:datalabel id="PieczątkaREGON" runat="server"></ea:datalabel>
				</p>
			</font>

			<table id="Table2" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:left">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">1.</td><td width="5px"></td>
					<td>Stwierdza się, że
						<ea:datalabel id="DataLabel2" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						<ea:datalabel id="Datalabel34" runat="server" DataMember="Pracownik.Imie"></ea:datalabel>
						<ea:datalabel id="Datalabel5" runat="server" DataMember="ImieDrugie"></ea:datalabel>
						<ea:datalabel id="Datalabel4" runat="server" DataMember="Pracownik.Nazwisko"></ea:datalabel>,
                        imiona rodziców:
						<ea:datalabel id="Datalabel36" runat="server" DataMember="ImieOjca"></ea:datalabel>,
						<ea:datalabel id="Datalabel37" runat="server" DataMember="ImieMatki"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel3" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="urodzona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="urodzony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;
						<ea:datalabel id="Datalabel38" runat="server" DataMember="Urodzony.Data"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel1" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="była zatrudniona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="był zatrudniony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;w:
                        <br />
                        <ea:datalabel id="labelZatrudnienie" runat="server" Bold="false"></ea:datalabel> 
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">2.</td><td width="5px"></td>
					<td>W okresie zatrudnienia pracownik wykonywał pracę tymczasową na rzecz:
						<ea:datalabel id="labelPracodawcy" runat="server"></ea:datalabel>
                    </td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">3.</td><td width="5px"></td>
					<td>W okresie zatrudnienia
						<ea:datalabel id="DataLabel11" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="pracownik wykonywał"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="pracownik wykonywał"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						pracę:
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="labelStanowisko" runat="server" Bold="False"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">4.</td><td width="5px"></td>
					<td>Stosunek pracy ustał w wyniku:</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
                        a) rozwiązania
                        <ea:datalabel id="labelPrzyczyna1" runat="server"></ea:datalabel>
                        <ea:Section ID="desc15" runat="server">
                            <em>(tryb i podstawa prawna rozwiązania stosunku pracy)</em>
                        </ea:Section><br />
                        b) wygaśnięcia
                        <ea:datalabel id="labelPrzyczyna2" runat="server"></ea:datalabel>
                        <ea:Section ID="desc16" runat="server">
                            <em>(podstawa prawna wygaśnięcia stosunku pracy)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">5.</td><td width="5px"></td>
					<td>Został zastosowany skrócony okres wypowiedzenia umowy o pracę na podstawie art. 36<sup>1</sup> § 1 Kodeksu pracy</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="skrOkres" runat="server"></ea:datalabel>
                        <ea:Section ID="desc1" runat="server">
                            <em>(okres, o który został skrócony okres wypowiedzenia, uprawniający do odszkodowania)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">6.</td><td width="5px"></td>
					<td>W okresie zatrudnienia pracownik:</td>
				</tr>
			</tbody>
			</table>
					
			<table id="Table3" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:left">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">1)</td><td width="5px"></td>
					<td>wykorzystał urlop wypoczynkowy w wymiarze&nbsp;
						<ea:datalabel id="wypoczynkowy" runat="server"></ea:datalabel>
						&nbsp;dni&nbsp;<ea:datalabel id="wypoczynkowyT" runat="server" Bold="False"></ea:datalabel>
						(<ea:datalabel id="wypoczynkowyG" runat="server"></ea:datalabel>
						&nbsp;godz.<ea:datalabel id="ekwiwalentG" runat="server" Bold="False"></ea:datalabel>)
                        <ea:Section ID="desc2" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany w roku kalendarzowym, w którym ustał stosunek pracy)</em><br/>
                        </ea:Section>
                        w tym
						<ea:datalabel id="wypoczynkowy167" runat="server"></ea:datalabel>&nbsp;dni
						(<ea:datalabel id="wypoczynkowy167G" runat="server"></ea:datalabel>&nbsp;godz.) 
						urlopu na żądanie
                        <ea:Section ID="desc3" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany na podstawie art. 167<sup>2</sup> Kodeksu pracy w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
                <tr>
					<td width="60px" valign="top" align="right">2)</td><td width="5px"></td>
					<td>korzystał z urlopu bezpłatnego:
                        <ea:datalabel id="urlopbezplatny" runat="server"></ea:datalabel>
                        <ea:Section ID="desc4" runat="server">
                            <em>(okres trwania urlopu bezpłatnego i podstawa prawna jego udzielenia)</em>
                        </ea:Section>
                    </td>
				</tr>
            </tbody>
            </table>				

			<ea:pagebreak id="PageBreak7" runat="server" Required="False"></ea:pagebreak>

			<table id="Table5" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">3)</td><td width="5px"></td>
					<td>wykorzystał urlop ojcowski w wymiarze:&nbsp;
						<ea:datalabel id="ojcowski" runat="server"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">4)</td><td width="5px"></td>
					<td>wykorzystał urlop rodzicielski udzielony na podstawie
                        art. 182<sup>1a</sup> Kodeksu pracy 
                        <ea:Section ID="desc5" runat="server">
                            <em>(podstawa prawna udzielenia urlopu)</em>
                        </ea:Section>
                        w wymiarze:&nbsp;
						<ea:datalabel id="rodzicielski" runat="server"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">5)</td><td width="5px"></td>
					<td>wykorzystał urlop wychowawczy udzielony na podstawie
                        art. 186 Kodeksu pracy 
                        <ea:Section ID="desc6" runat="server">
                            <em>(podstawa prawna udzielenia urlopu)</em>
                        </ea:Section>
                        w wymiarze:&nbsp;
						<ea:datalabel id="wychowawczy" runat="server"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">6)</td><td width="5px"></td>
					<td>korzystał z ochrony stosunku pracy, o której mowa w art. 186<sup>8</sup> § 1 pkt 2 Kodeksu pracy, w okresie (okresach):&nbsp;
						<ea:datalabel id="ochronny" runat="server"></ea:datalabel>
                    </td>
                </tr>
            </tbody>
            </table>

			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>

			<table id="Table6" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">7)</td><td width="5px"></td>
					<td>wykorzystał zwolnienie od pracy przewidziane w art. 188 Kodeksu pracy:&nbsp;
						<ea:datalabel id="opieka188" runat="server"></ea:datalabel>
                        <ea:Section ID="desc8" runat="server">
                            <em><ea:datalabel id="opieka188opis" runat="server" Bold="false"></ea:datalabel></em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">8)</td><td width="5px"></td>
					<td>był niezdolny do pracy przez okres:&nbsp;
						<ea:datalabel id="wynagrodz92" runat="server"></ea:datalabel>&nbsp;dni
                        <ea:Section ID="desc9" runat="server">
                            <em>(liczba dni, za które pracownik otrzymał wynagrodzenie - zgodnie z art. 92 Kodeksu pracy,
                            w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">9)</td><td width="5px"></td>
					<td>
						<ea:datalabel id="nieWyn" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc10" runat="server">
                            <em>(dni, za które pracownik nie zachował prawa do wynagrodzenia,
                                przypadające w okresie od dnia 1 stycznia 2003 r. do dnia 31 grudnia 2003 r.,
                                zgodnie z art. 92 § 1<sup>1</sup> Kodeksu pracy obowiązującym w tym okresie)</em>
                        </ea:Section>
					</td>
				</tr>
            </tbody>
            </table>

            <ea:pagebreak id="PageBreak9" runat="server" Required="False"></ea:pagebreak>

			<table id="Table8" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
                <tr>
					<td width="60px" valign="top" align="right">10)</td><td width="5px"></td>
					<td>odbył służbę wojskową w okresie:
						<ea:datalabel id="służba" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc11" runat="server">
                            <em>(okres odbywania czynnej służby wojskowej lub jej form zastępczych)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">11)</td><td width="5px"></td>
					<td>wykonywał pracę w szczególnych warunkach lub w szczególnym charakterze:
						<ea:datalabel id="szWarunki" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc12" runat="server">
    						<em>(okresy wykonywania pracy oraz jej rodzaj i zajmowane stanowiska)</em>
                        </ea:Section>
					</td>
				</tr>
            </tbody>
            </table>

            <ea:pagebreak id="PageBreak10" runat="server" Required="False"></ea:pagebreak>

			<table id="Table9" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">12)</td><td width="5px"></td>
					<td>wykorzystał dodatkowy urlop albo inne uprawnienia lub świadczenia 
						przewidziane przepisami prawa pracy:
						<ea:datalabel id="dodUrlop" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
            </tbody>
            </table>

            <ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>

			<table id="Table7" cellSpacing="2" cellpadding="2" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">13)</td><td width="5px"></td>
					<td>okresy nieskładkowe:&nbsp;
						<ea:datalabel id="okresyNS" runat="server" Bold="false"></ea:datalabel>
                        <ea:Section ID="desc13" runat="server">
                            <em>(okresy nieskładkowe, przypadające w okresie zatrudnienia wskazanym w ust. 1, 
						    uwzględniane przy ustalaniu prawa do emerytury lub renty)</em>
			            </ea:Section>
                    </td>
				</tr>
            </tbody>
            </table>

			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			
			<table id="Table11" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">7.</td><td width="5px"></td>
					<td>Informacja o zajęciu wynagrodzenia
                        <ea:Section ID="desc14" runat="server">
                            <em>(oznaczenie komornika i numer sprawy egzekucyjnej)</em>:&nbsp;
                        </ea:Section>
						<ea:datalabel id="komornik" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">8.</td><td width="5px"></td>
					<td>Informacje uzupełniające:&nbsp;
						<ea:datalabel id="dodatkowe" runat="server"></ea:datalabel><br/><br/>
					</td>
				</tr>
			</tbody>
			</table>
			
			<table id="Table12" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr height="30px">
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>.............................................................&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>
						<font size="1">(podpis pracodawcy lub osoby reprezentującej pracodawcę albo osoby upoważnionej do składania oświadczeń w imieniu pracodawcy)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</font>
					</td>
				</tr>
			</tbody>
			</table>
						
			<ea:pagebreak id="PageBreak6" runat="server" Required="False"></ea:pagebreak>
			
			<font face="Tahoma" size="1">
				<p style="text-align:justify">POUCZENIE<br/>
                    Pracownik może w ciągu 7 dni od otrzymania świadectwa pracy wystąpić do
                    pracodawcy z wnioskiem o sprostowanie tego świadectwa. W razie nieuwzględnienia
                    wniosku pracownikowi przysługuje, w ciągu 7 dni od otrzymania
                    zawiadomienia o odmowie sprostowania świadectwa pracy, prawo wystąpienia z
                    żądaniem sprostowania świadectwa pracy do
                    <ea:datalabel id="sadpracy" runat="server" Bold="false"></ea:datalabel>                    
                    (podstawa prawna - art. 97 § 2<sup>1</sup> Kodeksu pracy) 
				</p>
			</font>
			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        </form>
	</body>
</HTML>
